# Outer Wilds

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a
config file.

## What This Mod Changes

Randomizers in the Archipelago sense—which are sometimes called "Metroidvania-style" or "progression-based" randomizers—rely on the base game having several progression-blocking items you must find in order to complete the game.
In Outer Wilds progression is usually blocked by player knowledge rather than items, so to make a good randomizer we take away some of your starting equipment, and turn much of that player knowledge into items. Here are several examples:

- Translator
- Scout
- Signalscope frequencies
- Nomai Warp Codes (replaces "the player knowing how warp pads work" with a button prompt)
- Silent Running Mode (the fish have better hearing without this)
- Tornado Aerodynamic Adjustments
- Coordinates (since coordinates are randomized by default, you need this to finish)
- Autopilot
- Oxygen/Fuel Capacity Upgrades
- Oxygen/Fuel Refills
- Marshmallows
- and more

In randomizer terms: "items" are placed at randomly selected "locations" (while ensuring the game can still be completed). Most of the locations in this randomizer are:

- Notes, tape recorders and fuel tanks left by other Hearthians
- Translating pieces of Nomai text (e.g. the High Energy Lab experiment)
- Reaching important in-game places (e.g. the core of Giant's Deep)
- Scanning each Signalscope signal source
- Revealing facts in the Ship Log (which is usually also one of the above)

Complete lists and descriptions of all the items and locations in the randomizer can be found in-game in the ship log. Or in randomizer terms: we added an "in-game tracker" to the ship log. We strongly recommend using this tracker on your first randomizer playthrough to learn what you're supposed to be doing.

## Mod Compatibility

Outer Wilds story mods whose content has been fully integrated into this randomizer:

- [Astral Codec](https://outerwildsmods.com/mods/astralcodec/)
- [The Outsider](https://outerwildsmods.com/mods/theoutsider/)
- [Hearth's Neighbor](https://outerwildsmods.com/mods/hearthsneighbor/)
- [Hearth's Neighbor 2: Magistarium](https://outerwildsmods.com/mods/hearthsneighbor2magistarium/)
- [Fret's Quest](https://outerwildsmods.com/mods/fretsquest/)

Outer Wilds quality of life/tooling/etc mods that are known to work without issue:

- Clock
- Cheat and Debug Menu
- Suit Log
- Unity Explorer
- Light Bramble (thanks Rever for testing this), although it makes the "Silent Running Mode" item pointless
- Time Saver (thanks Jade for testing this)

## Credits

- GameWyrm for contributing this mod's in-game console, in-game tracker, and the banner art
- Smaller direct code/content contributors, including: thestrangepie (suitless logic), hopop201 (location names/descriptions), dgarroDC (bug fix)
- Amada, Axxroy, DCBomB, Groot, Hopop, Onemario, qwint, Rever, Scipio, Snow, and others in the "Archipelago" Discord server for feedback, discussion and encouragement
- clubby789, dgarroDC, GameWyrm, glitchewski, JohnCorby, nebula, Trifid, viovayo, xen and others from the "Outer Wilds Modding" Discord server for help learning how to mod Unity games in general and Outer Wilds in particular, and creating the other OW mods that this randomizer relies on or is often played with
- Nicopopxd for creating the Outer Wilds "Manual" for Archipelago
- Flitter for talking me into trying out Archipelago randomizers in the first place
- All the Archipelago contributors who made that great multi-randomizer system
- Everyone at Mobius who made this great game